<?php
/**
 * The list of icons included within the plugin
 *
 * @package YITH|Wishlist\PluginOptions
 */

/**
 * APPLY_FILTERS: yith_wcwl_icons_list_array
 *
 * Filter the array with all icons' information.
 *
 * @param array $icons Icons list.
 *
 * @return array
 */
return apply_filters(
	'yith_wcwl_icons_list_array',
	array(
		'bookmark'                          => array(
			'label' => _x( 'Bookmark', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'add-to-wishlist',
				'added-to-wishlist',
			),
		),
		'bookmark-outline'                  => array(
			'label' => _x( 'Bookmark outline', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'add-to-wishlist',
				'added-to-wishlist',
			),
		),
		'heart'                             => array(
			'label' => _x( 'Heart', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'add-to-wishlist',
				'added-to-wishlist',
			),
		),
		'heart-outline'                     => array(
			'label' => _x( 'Heart outline', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'add-to-wishlist',
				'added-to-wishlist',
			),
		),
		'heart-remove'                      => array(
			'label' => _x( 'Heart remove', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'add-to-wishlist',
				'added-to-wishlist',
			),
		),
		'heart-arrows'                      => array(
			'label' => _x( 'Heart arrows', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'add-to-wishlist',
				'added-to-wishlist',
				'move-to-another-wishlist',
			),
		),
		'heart-check'                       => array(
			'label' => _x( 'Heart check', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'add-to-wishlist',
				'added-to-wishlist',
			),
		),
		'star'                              => array(
			'label' => _x( 'Star', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'add-to-wishlist',
				'added-to-wishlist',
			),
		),
		'star-outline'                      => array(
			'label' => _x( 'Star outline', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'add-to-wishlist',
				'added-to-wishlist',
			),
		),
		'plus'                              => array(
			'label' => _x( 'Plus', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'add-to-cart',
			),
		),
		'plus-circle'                       => array(
			'label' => _x( 'Plus circle', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'added-to-wishlist',
				'add-to-wishlist',
				'add-to-cart',
			),
		),
		'plus-circle-outline'               => array(
			'label' => _x( 'Plus circle outline', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'added-to-wishlist',
				'add-to-wishlist',
				'add-to-cart',
			),
		),
		'shopping-bag'                      => array(
			'label' => _x( 'Shopping bag', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'add-to-cart',
			),
		),
		'shopping-bag-outline'              => array(
			'label' => _x( 'Shopping bag outline', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'add-to-cart',
			),
		),
		'shopping-cart'                     => array(
			'label' => _x( 'Shopping cart', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'add-to-cart',
			),
		),
		'shopping-cart-outline'             => array(
			'label' => _x( 'Shopping cart outline', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'add-to-cart',
			),
		),
		'calculator'                        => array(
			'label' => _x( 'Calculator', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'ask-an-estimate',
			),
		),
		'calculator-outline'                => array(
			'label' => _x( 'Calculator outline', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'ask-an-estimate',
			),
		),
		'chat-bubble-left-ellipsis'         => array(
			'label' => _x( 'Chat bubble', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'ask-an-estimate',
			),
		),
		'chat-bubble-left-ellipsis-outline' => array(
			'label' => _x( 'Chat bubble outline', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'ask-an-estimate',
			),
		),
		'document-arrow-up'                 => array(
			'label' => _x( 'Document arrow up', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'ask-an-estimate',
			),
		),
		'document-arrow-up-outline'         => array(
			'label' => _x( 'Document arrow up outline', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'ask-an-estimate',
			),
		),
		'document-chart-bar'                => array(
			'label' => _x( 'Document chart bar', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'ask-an-estimate',
			),
		),
		'document-chart-bar-outline'        => array(
			'label' => _x( 'Document chart bar outline', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'ask-an-estimate',
			),
		),
		'document-text'                     => array(
			'label' => _x( 'Document text', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'ask-an-estimate',
			),
		),
		'document-text-outline'             => array(
			'label' => _x( 'Document text outline', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'ask-an-estimate',
			),
		),
		'question-mark-circle'              => array(
			'label' => _x( 'Question mark', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'ask-an-estimate',
			),
		),
		'question-mark-circle-outline'      => array(
			'label' => _x( 'Question mark outline', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'ask-an-estimate',
			),
		),
		'receipt-percent'                   => array(
			'label' => _x( 'Receipt percent', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'ask-an-estimate',
			),
		),
		'receipt-percent-outline'           => array(
			'label' => _x( 'Receipt percent outline', '[Admin] The icon label show in the select', 'yith-woocommerce-wishlist' ),
			'tags'  => array(
				'ask-an-estimate',
			),
		),
	)
);